// By EVOLVED
// www.evolved-software.com

//--------------
// Textures
//--------------
   texture CubeTexture <string Name = " ";>;
   sampler CubeSampler=sampler_state 
      {
	Texture=<CubeTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MipFilter=None;
	MinFilter=None;
	MagFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION; 
     };
   struct OutPut
     {
 	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN)
     {
        OutPut OUT;
	OUT.Pos=IN.Pos;
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5);
        return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS(OutPut IN)  : COLOR
     {
	float3 EqVec=0;
	EqVec.x=cos(IN.Tex.x*6.2831852);
	EqVec.y=(1-IN.Tex.y)*2-1;
	EqVec.z=sin(IN.Tex.x*6.2831852);
	EqVec.y=tan(EqVec.y*1.5707963);
	EqVec=normalize(float3(-EqVec.x,-EqVec.y,EqVec.z));
	float3 CubeFace=abs(EqVec), CubeSign=sign(EqVec);
    	CubeFace=max(1-floor(max(CubeFace.zxx,CubeFace.yzy)/CubeFace.xyz),0.0);
	float2 Uv=(float2(-EqVec.z,EqVec.y*CubeSign.x)/EqVec.x*0.999)*CubeFace.x+
		  (float2(EqVec.x*-CubeSign.y,EqVec.z)/EqVec.y*0.999)*CubeFace.y+
		  (float2(EqVec.x,-EqVec.y*-CubeSign.z)/EqVec.z*0.999)*CubeFace.z;
	Uv=Uv*float2(0.166666,0.25)+float2(0.166666666+0.333333*CubeFace.y+0.666666*CubeFace.z,0.250000000);
	Uv.y +=0.25+dot(CubeSign,CubeFace)*0.25;
	float4 Reflection=tex2Dlod(CubeSampler,float4(Uv,0.0,0.0));
	float MaxComponent=max(max(Reflection.x,Reflection.y),Reflection.z);
	float fExp=ceil(log(MaxComponent)/log(1.04));
	fExp=saturate((fExp+128.0)/255.0);
	return float4(Reflection.xyz/pow(1.04,fExp*255.0-128.0),fExp);
     }

//--------------
// techniques   
//--------------
    technique Equirectangular
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS(); 
      }
      }
